/**************************************************************************************

   Copyright (c) Hilscher GmbH. All Rights Reserved.

 **************************************************************************************

   Filename:
    $Workfile: VARANApp_Public.h $
   Last Modification:
    $Author: Dimitar $
    $Modtime: 31.07.06 9:55 $
    $Revision: 12 $

   Targets:
    Win32/ANSI   : no
    Win32/Unicode: no (define _UNICODE)
    WinCE        : yes
    rcX          : yes

   Description:

    VARAN App
    public

   Changes:

     Version    Date        Author
        Description
     ----------------------------------------------------------------------------------

**************************************************************************************/
/**
 * @file VARANApp_Public.h
 *  VARAN App - public definition of task
 *
 * The header contains the public definition of task.
 * It has to be included by another task to get access of task specfic definition.
 *
 * @note
 * The structures for the services must be packed on 1 byte of boundary.
 * The <code>#pragma</code> instructions are already planned for Microsoft compiler.
 * For gnu's compiler and Realview compiler the macros <code>__PACKED_PRE</code>
 * and <code>__PACKED_PRE</code> have to be added with the structural definition
 * in addition.
 */

#ifndef __VARAN_APP_PUBLIC_H
#define __VARAN_APP_PUBLIC_H

#include "VARANStack_Public.h"


/** queue name */
#define VARAN_APP_QUEUE_NAME                          "QUE_VRN_APP"

/** @} */
#define VARAN_CLIENT_APP_CMD_SET_CONFIGURATION_REQ    (0x00007000)
#define VARAN_CLIENT_APP_CMD_SET_CONFIGURATION_CNF    (0x00007001)

#define VARAN_CLIENT_APP_CMD_WATCHDOG_IND             (0x00007002)
#define VARAN_CLIENT_APP_CMD_WATCHDOG_RES              (0x00007003)


/** used @ ulSystemFlags */
#define VARAN_CLIENT_SYS_FLAG_APPL_CNTRLD             (0x00000001)

/** used @ ulAppMode */
#define VARAN_CLIENT_APP_MODE_IO                      (0x00000000)

/*************************************************************************************/
/* packets */

/* pragma pack */
#ifdef PRAGMA_PACK_ENABLE
#pragma PRAGMA_PACK_1(__VARAN_CLIENT_APP_PACKET)
#endif

#define VARAN_CLIENT_APP_WATCHDOG_TIME_MIN            (0x0014)
#define VARAN_CLIENT_APP_WATCHDOG_TIME_MAX            (0xFFFF)

/********************************************************
 *  VARAN Client App. - Packet - Set Configuration.Req/Cnf
 ********************************************************/
typedef __PACKED_PRE struct __PACKED_POST VARAN_CLIENT_APP_DATA_INIT_REQ_Ttag{
  /** Application Interface Initialization  */
  TLR_UINT32  ulSystemFlags;           /* System flags          */
  TLR_UINT32  ulWdgTime;               /* App. Watchdog timeout */
  TLR_UINT32  ulAppMode;               /* App. Mode             */
  TLR_UINT8   abReserved[20];          /* App. Param Reserved   */
}VARAN_CLIENT_APP_DATA_INIT_REQ_T;

typedef __PACKED_PRE struct __PACKED_POST VARAN_CLIENT_APP_DATA_SET_CONFIGURATION_REQ_Ttag{
  VARAN_CLIENT_APP_DATA_INIT_REQ_T    tAppInitData;
  VARAN_CLIENT_STACK_DATA_INIT_REQ_T  tStackInitData;
}VARAN_CLIENT_APP_DATA_SET_CONFIGURATION_REQ_T;

#define  VARAN_CLIENT_APP_PCK_SET_CONFIGURATION_REQ_LEN       (sizeof(VARAN_CLIENT_APP_DATA_SET_CONFIGURATION_REQ_T))

typedef __PACKED_PRE struct __PACKED_POST  VARAN_CLIENT_APP_PCK_SET_CONFIGURATION_REQ_Ttag{
  TLR_PACKET_HEADER_T                            tHead;
  VARAN_CLIENT_APP_DATA_SET_CONFIGURATION_REQ_T  tData;
}VARAN_CLIENT_APP_PCK_SET_CONFIGURATION_REQ_T;

#define  VARAN_CLIENT_APP_PCK_SET_CONFIGURATION_CNF_SIZE       (0)
typedef __PACKED_PRE struct __PACKED_POST  VARAN_CLIENT_APP_PCK_SET_CONFIGURATION_CNF_Ttag{
  TLR_PACKET_HEADER_T           tHead;
}VARAN_CLIENT_APP_PCK_SET_CONFIGURATION_CNF_T;

/*************************************************************************/


/* pragma unpack */
#ifdef PRAGMA_PACK_ENABLE
#pragma PRAGMA_UNPACK_1(__VARAN_CLIENT_APP_PACKET)
#endif


/*************************************************************************************/
#endif /* #ifndef __VARAN_APP_PUBLIC_H */
